/**
 * 
 */
package gov.va.med.mhv.common.api.security;

import java.io.IOException;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.exception.MHVException;

/**
 * @author DNS
 *
 */
public class MHVSecureTokenRequestFilter implements ClientRequestFilter {
	
	private static final String API_TOKEN_KEY = "Token";

	/* (non-Javadoc)
	 * @see javax.ws.rs.client.ClientRequestFilter#filter(javax.ws.rs.client.ClientRequestContext)
	 */
	@Override
	public void filter(ClientRequestContext requestContext) throws IOException {
		
		try {
			
			String token = CacheHandler.getInstance().getToken();
			
			if(token != null) {
				requestContext.getHeaders().add(API_TOKEN_KEY, token);
			}
			else {
				throw new MHVException(ErrorEnum.AUTHENTICATION_SESSION_UNAVAILABLE_902);
			}
		
		} catch (Exception e) {
			throw new IOException("Error handing token off to service client.", e);
		}

	}

}
